package AppGioco.QuadroDedicato;

import AppGioco.*;
import AppGioco.Quadro.*;

public class QuadroDedicato extends Quadro {
	protected String fileFilmato;
	protected TipoLinkDedicatoA dedicato;

	public QuadroDedicato(String fa, String ff) {
		super(fa);
		fileFilmato = ff;
		dedicato = null;
	}

	public String getFileFilmato() {
		return fileFilmato;
	}

	public void setFileFilmato(String ff) {
		fileFilmato = ff;
	}

	public boolean estPresenteLinkDedicatoA() {
		return dedicato != null;
	}
	public void inserisciLinkDedicatoA(TipoLinkDedicatoA t) {
		if (t != null && t.getQuadroDedicato()==this)
			ManagerDedicatoA.inserisci(t);
	}

	public void eliminaLinkDedicatoA(TipoLinkDedicatoA t) {
		if (t != null && t.getQuadroDedicato()==this)
			ManagerDedicatoA.elimina(t);
	}
	public void inserisciPerManagerDedicatoA(ManagerDedicatoA a) {
		if (a != null)
			dedicato = a.getLink();
	}

	public void eliminaPerManagerDedicatoA(ManagerDedicatoA a) {
		if (a != null)
			dedicato = null;
	}

	public TipoLinkDedicatoA getLinkDedicatoA() throws EccezioneMolteplicita,
			EccezioneSubset {
		if (!estPresenteLinkDedicatoA())
			throw new EccezioneMolteplicita("Violata molteplicit minima");
		if (!dedicato.getPersonaggio().getLinkPresente().contains(this))
			throw new EccezioneSubset("dedicatoA non  un subset di presente");
		return dedicato;
	}
}
